<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
	/**
	 * Run the migrations.
	 */
	public function up(): void
	{
		Schema::create('content_tag_pivots', function (Blueprint $table) {
			$table->id();
			$table->foreignId('content_id')->constrained()->onDelete('cascade');
			$table->foreignId('tag_id')->constrained()->onDelete('cascade');
			$table->unique(['content_id', 'tag_id']);
			$table->timestamps();
		});
	}

	/**
	 * Reverse the migrations.
	 */
	public function down(): void
	{
		Schema::dropIfExists('content_tag_pivots');
	}
};
