<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\DB;

class UserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $users = [
            [
                'firstname' => 'Admin',
                'lastname' => 'User',
                'username' => 'admin',
                'role' => 'admin',
                'email' => 'admin@gmail.com',
                'password' => Hash::make('12345678'),
                'bio' => 'The super admin of the platform.',
                'profile_pic' => null,
                'banner_pic' => null,
                'email_verified_at' => now(),
            ],
            [
                'firstname' => 'John',
                'lastname' => 'Doe',
                'username' => 'john_doe',
                'role' => 'fans',
                'email' => 'john@gmail.com',
                'password' => Hash::make('12345678'),
                'bio' => 'Just a regular fan.',
                'profile_pic' => null,
                'banner_pic' => null,
                'email_verified_at' => now(),
            ],
            [
                'firstname' => 'Jane',
                'lastname' => 'Smith',
                'username' => 'jane_smith',
                'role' => 'creator',
                'email' => 'jane@gmail.com',
                'password' => Hash::make('12345678'),
                'bio' => 'Creative content creator.',
                'profile_pic' => null,
                'banner_pic' => null,
                'email_verified_at' => now(),
            ],
            [
                'firstname' => 'Alice',
                'lastname' => 'Wonder',
                'username' => 'alice_wonder',
                'role' => 'fans',
                'email' => 'alice@gmail.com',
                'password' => Hash::make('12345678'),
                'bio' => 'Love to follow creators.',
                'profile_pic' => null,
                'banner_pic' => null,
                'email_verified_at' => now(),
            ],
            [
                'firstname' => 'Bob',
                'lastname' => 'Builder',
                'username' => 'bob_builder',
                'role' => 'creator',
                'email' => 'bob@gmail.com',
                'password' => Hash::make('12345678'),
                'bio' => 'Building content daily.',
                'profile_pic' => null,
                'banner_pic' => null,
                'email_verified_at' => now(),
            ],
        ];

        foreach ($users as $user) {
            User::create($user);
        }

    }
}
